using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Drawing.Imaging;

namespace ImageContainer
{
    public partial class ImageForm : Form
    {
        private Image image;
        private Bitmap bitmap;
        private bool shouldPaint = false;
        private int startX=-1;
        private int startY, endX, endY;

        public ImageForm(Image im)
        {
            image = im;
            bitmap = new Bitmap(image);
            InitializeComponent();
        }

        private void ImageForm_MouseMove(object sender, MouseEventArgs e)
        {
         /*   if (shouldPaint)
            {
                Graphics graphics = CreateGraphics();
                SolidBrush brush = new SolidBrush(Color.Blue);
                graphics.FillEllipse(brush, e.X, e.Y, 4, 4);
                graphics.Dispose();
            }*/
        }

        private void ImageForm_MouseDown(object sender, MouseEventArgs e)
        {
            //shouldPaint = true;
            if (startX < 0)
            {
                startX = e.X;
                startY = e.Y;
            }
            else
            {
                endX = e.X;
                endY = e.Y;
                Graphics graphics = CreateGraphics();
                Pen whitePen = new Pen(Color.White, 2);
                graphics.DrawRectangle(whitePen, new Rectangle(startX,startY,endX-startX,endY-startY));
            }
        }

        private void ImageForm_MouseUp(object sender, MouseEventArgs e)
        {
          //  shouldPaint = false;
        }

        private void ImageForm_Paint(object sender, PaintEventArgs e)
        {
            Graphics graphics = e.Graphics;
            graphics.DrawImage(bitmap, new Point(20,20));
        }

        public void invertImage()
        {
            BitmapData data = bitmap.LockBits(new Rectangle(0, 0, bitmap.Width, bitmap.Height), 
                                              ImageLockMode.ReadWrite, PixelFormat.Format24bppRgb);
            unsafe
            {
                byte* imgPtr = (byte*)(data.Scan0);
                for (int i = 0; i < data.Height; i++)
                {
                    for (int j = 0; j < data.Width; j++)
                    {
                        // write the logic implementation here
                        (*imgPtr) = (byte)( 255 - (*imgPtr++));  //R
                        (*imgPtr) = (byte) (255 - (*imgPtr++));  //G
                        (*imgPtr) =(byte)( 255 - (*imgPtr++)); //B 
                        
                        //imgPtr += 3;
                    }
                    imgPtr += data.Stride - data.Width * 3;
                }
           }

           bitmap.UnlockBits(data);

           Invalidate();

            /*for (int x = 0; x < bitmap.Width; x++)
                for (int y = 0; y < bitmap.Height; y++)
                {
                    Color rgb=bitmap.GetPixel(x,y);
                    Color invrgb = Color.FromArgb(255 - rgb.R, 255 - rgb.G, 255 - rgb.B);
                    bitmap.SetPixel(x, y, invrgb);
                }*/

        }
    }
}